# generated by datamodel-codegen:
#   filename:  https://ai.google.dev/static/api/interactions.openapi.json
#   timestamp: 2025-12-16T21:25:12+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Literal, Optional, Union

from pydantic import AwareDatetime, Base64Str, BaseModel, Field, RootModel


class Annotation(BaseModel):
    start_index: Optional[int] = Field(
        None,
        description='Start of segment of the response that is attributed to this source.\n\nIndex indicates the start of the segment, measured in bytes.',
    )
    end_index: Optional[int] = Field(
        None, description='End of the attributed segment, exclusive.'
    )
    source: Optional[str] = Field(
        None,
        description='Source attributed for a portion of the text. Could be a URL, title, or\nother identifier.',
    )


class DocumentContent(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[str] = None
    type: Literal['document'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class FunctionCallContent(BaseModel):
    name: str = Field(..., description='The name of the tool to call.')
    arguments: Dict[str, Any] = Field(
        ..., description='The arguments to pass to the function.'
    )
    type: Literal['function_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: str = Field(..., description='A unique ID for this specific tool call.')


class Language(Enum):
    python = 'python'


class CodeExecutionCallArguments(BaseModel):
    language: Optional[Language] = Field(
        None, description='Programming language of the `code`.'
    )
    code: Optional[str] = Field(None, description='The code to be executed.')


class UrlContextCallArguments(BaseModel):
    urls: Optional[List[str]] = Field(None, description='The URLs to fetch.')


class McpServerToolCallContent(BaseModel):
    name: str = Field(..., description='The name of the tool which was called.')
    server_name: str = Field(..., description='The name of the used MCP server.')
    arguments: Dict[str, Any] = Field(
        ..., description='The JSON object of arguments for the function.'
    )
    type: Literal['mcp_server_tool_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: str = Field(..., description='A unique ID for this specific tool call.')


class GoogleSearchCallArguments(BaseModel):
    queries: Optional[List[str]] = Field(
        None, description='Web search queries for the following-up web search.'
    )


class CodeExecutionResultContent(BaseModel):
    result: Optional[str] = Field(None, description='The output of the code execution.')
    is_error: Optional[bool] = Field(
        None, description='Whether the code execution resulted in an error.'
    )
    signature: Optional[str] = Field(
        None, description='A signature hash for backend validation.'
    )
    type: Literal['code_execution_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the code execution call block.'
    )


class Status(Enum):
    success = 'success'
    error = 'error'
    paywall = 'paywall'
    unsafe = 'unsafe'


class UrlContextResult(BaseModel):
    url: Optional[str] = Field(None, description='The URL that was fetched.')
    status: Optional[Status] = Field(
        None, description='The status of the URL retrieval.'
    )


class GoogleSearchResult(BaseModel):
    url: Optional[str] = Field(None, description='URI reference of the search result.')
    title: Optional[str] = Field(None, description='Title of the search result.')
    rendered_content: Optional[str] = Field(
        None,
        description='Web content snippet that can be embedded in a web page or an app webview.',
    )


class FileSearchResult(BaseModel):
    title: Optional[str] = Field(None, description='The title of the search result.')
    text: Optional[str] = Field(None, description='The text of the search result.')
    file_search_store: Optional[str] = Field(
        None, description='The name of the file search store.'
    )


class SpeechConfig(BaseModel):
    voice: Optional[str] = Field(None, description='The voice of the speaker.')
    language: Optional[str] = Field(None, description='The language of the speech.')
    speaker: Optional[str] = Field(
        None,
        description="The speaker's name, it should match the speaker name given in the prompt.",
    )


class DynamicAgentConfig(BaseModel):
    type: Literal['dynamic'] = Field(
        'dynamic',
        description='Used as the OpenAPI type discriminator for the content oneof.',
    )


class Function(BaseModel):
    name: Optional[str] = Field(None, description='The name of the function.')
    description: Optional[str] = Field(
        None, description='A description of the function.'
    )
    parameters: Optional[Any] = Field(
        None, description="The JSON Schema for the function's parameters."
    )
    type: Literal['function']


class CodeExecution(BaseModel):
    type: Literal['code_execution']


class UrlContext(BaseModel):
    type: Literal['url_context']


class Environment(Enum):
    browser = 'browser'


class ComputerUse(BaseModel):
    type: Literal['computer_use']
    environment: Optional[Environment] = Field(
        None, description='The environment being operated.'
    )
    excludedPredefinedFunctions: Optional[List[str]] = Field(
        None,
        description='The list of predefined functions that are excluded from the model call.',
    )


class GoogleSearch(BaseModel):
    type: Literal['google_search']


class FileSearch(BaseModel):
    file_search_store_names: Optional[List[str]] = Field(
        None, description='The file search store names to search.'
    )
    top_k: Optional[int] = Field(
        None, description='The number of semantic retrieval chunks to retrieve.'
    )
    metadata_filter: Optional[str] = Field(
        None,
        description='Metadata filter to apply to the semantic retrieval documents and chunks.',
    )
    type: Literal['file_search']


class EventType(Enum):
    interaction_start = 'interaction.start'
    interaction_complete = 'interaction.complete'


class Status1(Enum):
    in_progress = 'in_progress'
    requires_action = 'requires_action'
    completed = 'completed'
    failed = 'failed'
    cancelled = 'cancelled'


class InteractionStatusUpdate(BaseModel):
    interaction_id: Optional[str] = None
    status: Optional[Status1] = None
    event_type: Literal['interaction.status_update'] = 'interaction.status_update'
    event_id: Optional[str] = Field(
        None,
        description='The event_id token to be used to resume the interaction stream, from\nthis event.',
    )


class TextDelta(BaseModel):
    text: Optional[str] = None
    type: Literal['text'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    annotations: Optional[List[Annotation]] = Field(
        None, description='Citation information for model-generated content.'
    )


class DocumentDelta(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[str] = None
    type: Literal['document'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class ThoughtSignatureDelta(BaseModel):
    signature: Optional[Base64Str] = Field(
        None,
        description='Signature to match the backend source to be part of the generation.',
    )
    type: Literal['thought_signature'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class FunctionCallDelta(BaseModel):
    name: Optional[str] = None
    arguments: Optional[Dict[str, Any]] = None
    type: Literal['function_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class CodeExecutionCallDelta(BaseModel):
    arguments: Optional[CodeExecutionCallArguments] = None
    type: Literal['code_execution_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class UrlContextCallDelta(BaseModel):
    arguments: Optional[UrlContextCallArguments] = None
    type: Literal['url_context_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class GoogleSearchCallDelta(BaseModel):
    arguments: Optional[GoogleSearchCallArguments] = None
    type: Literal['google_search_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class McpServerToolCallDelta(BaseModel):
    name: Optional[str] = None
    server_name: Optional[str] = None
    arguments: Optional[Dict[str, Any]] = None
    type: Literal['mcp_server_tool_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class CodeExecutionResultDelta(BaseModel):
    result: Optional[str] = None
    is_error: Optional[bool] = None
    signature: Optional[str] = None
    type: Literal['code_execution_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the function call block.'
    )


class UrlContextResultDelta(BaseModel):
    signature: Optional[str] = None
    result: Optional[List[UrlContextResult]] = None
    is_error: Optional[bool] = None
    type: Literal['url_context_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the function call block.'
    )


class GoogleSearchResultDelta(BaseModel):
    signature: Optional[str] = None
    result: Optional[List[GoogleSearchResult]] = None
    is_error: Optional[bool] = None
    type: Literal['google_search_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the function call block.'
    )


class FileSearchResultDelta(BaseModel):
    result: Optional[List[FileSearchResult]] = None
    type: Literal['file_search_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class ContentStop(BaseModel):
    index: Optional[int] = None
    event_type: Literal['content.stop'] = 'content.stop'
    event_id: Optional[str] = Field(
        None,
        description='The event_id token to be used to resume the interaction stream, from\nthis event.',
    )


class Error(BaseModel):
    code: Optional[str] = Field(
        None, description='A URI that identifies the error type.'
    )
    message: Optional[str] = Field(None, description='A human-readable error message.')


class MediaResolution(Enum):
    low = 'low'
    medium = 'medium'
    high = 'high'


class ToolChoiceType(Enum):
    auto = 'auto'
    any = 'any'
    none = 'none'
    validated = 'validated'


class ThinkingLevel(Enum):
    low = 'low'
    high = 'high'


class ThinkingSummaries(Enum):
    auto = 'auto'
    none = 'none'


class ResponseModality(Enum):
    text = 'text'
    image = 'image'
    audio = 'audio'


class Status3(Enum):
    UNSPECIFIED = 'UNSPECIFIED'
    IN_PROGRESS = 'IN_PROGRESS'
    REQUIRES_ACTION = 'REQUIRES_ACTION'
    COMPLETED = 'COMPLETED'
    FAILED = 'FAILED'
    CANCELLED = 'CANCELLED'


class ModelOption(RootModel[str]):
    root: str = Field(
        ...,
        description='The model that will complete your prompt.\\n\\nSee [models](https://ai.google.dev/gemini-api/docs/models) for additional details.',
        title='Model',
    )


class AgentOption(RootModel[str]):
    root: str = Field(..., description='The agent to interact with.', title='Agent')


class ImageMimeTypeOption(RootModel[str]):
    root: str = Field(
        ..., description='The mime type of the image.', title='ImageMimeType'
    )


class AudioMimeTypeOption(RootModel[str]):
    root: str = Field(
        ..., description='The mime type of the audio.', title='AudioMimeType'
    )


class VideoMimeTypeOption(RootModel[str]):
    root: str = Field(
        ..., description='The mime type of the video.', title='VideoMimeType'
    )


class TextContent(BaseModel):
    text: Optional[str] = Field(None, description='The text content.')
    type: Literal['text'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    annotations: Optional[List[Annotation]] = Field(
        None, description='Citation information for model-generated content.'
    )


class ImageContent(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[ImageMimeTypeOption] = None
    type: Literal['image'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    resolution: Optional[MediaResolution] = Field(
        None, description='The resolution of the media.'
    )


class AudioContent(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[AudioMimeTypeOption] = None
    type: Literal['audio'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class VideoContent(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[VideoMimeTypeOption] = None
    type: Literal['video'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    resolution: Optional[MediaResolution] = Field(
        None, description='The resolution of the media.'
    )


class ThoughtSummary1(RootModel[Union[TextContent, ImageContent]]):
    root: Union[TextContent, ImageContent] = Field(..., discriminator='type')


class ThoughtSummary(RootModel[List[ThoughtSummary1]]):
    root: List[ThoughtSummary1] = Field(..., description='A summary of the thought.')


class CodeExecutionCallContent(BaseModel):
    arguments: Optional[CodeExecutionCallArguments] = Field(
        None, description='The arguments to pass to the code execution.'
    )
    type: Literal['code_execution_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class UrlContextCallContent(BaseModel):
    arguments: Optional[UrlContextCallArguments] = Field(
        None, description='The arguments to pass to the URL context.'
    )
    type: Literal['url_context_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class GoogleSearchCallContent(BaseModel):
    arguments: Optional[GoogleSearchCallArguments] = Field(
        None, description='The arguments to pass to Google Search.'
    )
    type: Literal['google_search_call'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    id: Optional[str] = Field(
        None, description='A unique ID for this specific tool call.'
    )


class Result(BaseModel):
    items: Optional[List[Union[str, ImageContent]]] = None


class FunctionResultContent(BaseModel):
    name: Optional[str] = Field(
        None, description='The name of the tool that was called.'
    )
    is_error: Optional[bool] = Field(
        None, description='Whether the tool call resulted in an error.'
    )
    type: Literal['function_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    result: Union[Result, Dict[str, Any], str] = Field(
        ..., description='The result of the tool call.'
    )
    call_id: str = Field(
        ..., description='ID to match the ID from the function call block.'
    )


class UrlContextResultContent(BaseModel):
    signature: Optional[str] = Field(
        None, description='The signature of the URL context result.'
    )
    result: Optional[List[UrlContextResult]] = Field(
        None, description='The results of the URL context.'
    )
    is_error: Optional[bool] = Field(
        None, description='Whether the URL context resulted in an error.'
    )
    type: Literal['url_context_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the url context call block.'
    )


class GoogleSearchResultContent(BaseModel):
    signature: Optional[str] = Field(
        None, description='The signature of the Google Search result.'
    )
    result: Optional[List[GoogleSearchResult]] = Field(
        None, description='The results of the Google Search.'
    )
    is_error: Optional[bool] = Field(
        None, description='Whether the Google Search resulted in an error.'
    )
    type: Literal['google_search_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the google search call block.'
    )


class McpServerToolResultContent(BaseModel):
    name: Optional[str] = Field(
        None,
        description='Name of the tool which is called for this specific tool call.',
    )
    server_name: Optional[str] = Field(
        None, description='The name of the used MCP server.'
    )
    type: Literal['mcp_server_tool_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    result: Union[Result, Dict[str, Any], str] = Field(
        ..., description='The result of the tool call.'
    )
    call_id: str = Field(
        ..., description='ID to match the ID from the MCP server tool call block.'
    )


class FileSearchResultContent(BaseModel):
    result: Optional[List[FileSearchResult]] = Field(
        None, description='The results of the File Search.'
    )
    type: Literal['file_search_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class AllowedTools(BaseModel):
    mode: Optional[ToolChoiceType] = Field(
        None, description='The mode of the tool choice.'
    )
    tools: Optional[List[str]] = Field(
        None, description='The names of the allowed tools.'
    )


class DeepResearchAgentConfig(BaseModel):
    type: Literal['deep-research'] = Field(
        'deep-research',
        description='Used as the OpenAPI type discriminator for the content oneof.',
    )
    thinking_summaries: Optional[ThinkingSummaries] = Field(
        None, description='Whether to include thought summaries in the response.'
    )


class McpServer(BaseModel):
    type: Literal['mcp_server']
    name: Optional[str] = Field(None, description='The name of the MCPServer.')
    url: Optional[str] = Field(
        None,
        description='The full URL for the MCPServer endpoint.\nExample: "https://api.example.com/mcp"',
    )
    headers: Optional[Dict[str, str]] = Field(
        None,
        description='Optional: Fields for authentication headers, timeouts, etc., if needed.',
    )
    allowed_tools: Optional[List[AllowedTools]] = Field(
        None, description='The allowed tools.'
    )


class ModalityTokens(BaseModel):
    modality: Optional[ResponseModality] = Field(
        None, description='The modality associated with the token count.'
    )
    tokens: Optional[int] = Field(
        None, description='Number of tokens for the modality.'
    )


class ImageDelta(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[ImageMimeTypeOption] = None
    type: Literal['image'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    resolution: Optional[MediaResolution] = Field(
        None, description='The resolution of the media.'
    )


class AudioDelta(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[AudioMimeTypeOption] = None
    type: Literal['audio'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )


class VideoDelta(BaseModel):
    data: Optional[Base64Str] = None
    uri: Optional[str] = None
    mime_type: Optional[VideoMimeTypeOption] = None
    type: Literal['video'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    resolution: Optional[MediaResolution] = Field(
        None, description='The resolution of the media.'
    )


class ThoughtSummaryDelta(BaseModel):
    type: Literal['thought_summary'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    content: Optional[Union[TextContent, ImageContent]] = Field(
        None, discriminator='type'
    )


class FunctionResultDelta(BaseModel):
    name: Optional[str] = None
    is_error: Optional[bool] = None
    type: Literal['function_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    result: Optional[Union[Result, str]] = Field(
        None, description='Tool call result delta.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the function call block.'
    )


class McpServerToolResultDelta(BaseModel):
    name: Optional[str] = None
    server_name: Optional[str] = None
    type: Literal['mcp_server_tool_result'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    result: Optional[Union[Result, str]] = Field(
        None, description='Tool call result delta.'
    )
    call_id: Optional[str] = Field(
        None, description='ID to match the ID from the function call block.'
    )


class ErrorEvent(BaseModel):
    event_type: Literal['error'] = 'error'
    error: Optional[Error] = None
    event_id: Optional[str] = Field(
        None,
        description='The event_id token to be used to resume the interaction stream, from\nthis event.',
    )


class ToolChoiceConfig(BaseModel):
    allowed_tools: Optional[AllowedTools] = None


class Tool(
    RootModel[
        Union[
            Function,
            GoogleSearch,
            CodeExecution,
            UrlContext,
            ComputerUse,
            McpServer,
            FileSearch,
        ]
    ]
):
    root: Union[
        Function,
        GoogleSearch,
        CodeExecution,
        UrlContext,
        ComputerUse,
        McpServer,
        FileSearch,
    ] = Field(..., discriminator='type')


class ThoughtContent(BaseModel):
    signature: Optional[Base64Str] = Field(
        None,
        description='Signature to match the backend source to be part of the generation.',
    )
    type: Literal['thought'] = Field(
        ..., description='Used as the OpenAPI type discriminator for the content oneof.'
    )
    summary: Optional[ThoughtSummary] = Field(
        None, description='A summary of the thought.'
    )


class ToolChoice(RootModel[Union[ToolChoiceType, ToolChoiceConfig]]):
    root: Union[ToolChoiceType, ToolChoiceConfig] = Field(
        ..., description='The configuration for tool choice.'
    )


class Usage(BaseModel):
    total_input_tokens: Optional[int] = Field(
        None, description='Number of tokens in the prompt (context).'
    )
    input_tokens_by_modality: Optional[List[ModalityTokens]] = Field(
        None, description='A breakdown of input token usage by modality.'
    )
    total_cached_tokens: Optional[int] = Field(
        None,
        description='Number of tokens in the cached part of the prompt (the cached content).',
    )
    cached_tokens_by_modality: Optional[List[ModalityTokens]] = Field(
        None, description='A breakdown of cached token usage by modality.'
    )
    total_output_tokens: Optional[int] = Field(
        None, description='Total number of tokens across all the generated responses.'
    )
    output_tokens_by_modality: Optional[List[ModalityTokens]] = Field(
        None, description='A breakdown of output token usage by modality.'
    )
    total_tool_use_tokens: Optional[int] = Field(
        None, description='Number of tokens present in tool-use prompt(s).'
    )
    tool_use_tokens_by_modality: Optional[List[ModalityTokens]] = Field(
        None, description='A breakdown of tool-use token usage by modality.'
    )
    total_reasoning_tokens: Optional[int] = Field(
        None, description='Number of tokens of thoughts for thinking models.'
    )
    total_tokens: Optional[int] = Field(
        None,
        description='Total token count for the interaction request (prompt + responses + other\ninternal tokens).',
    )


class ContentDelta(BaseModel):
    index: Optional[int] = None
    event_type: Literal['content.delta'] = 'content.delta'
    event_id: Optional[str] = Field(
        None,
        description='The event_id token to be used to resume the interaction stream, from\nthis event.',
    )
    delta: Optional[
        Union[
            TextDelta,
            ImageDelta,
            AudioDelta,
            DocumentDelta,
            VideoDelta,
            ThoughtSummaryDelta,
            ThoughtSignatureDelta,
            FunctionCallDelta,
            FunctionResultDelta,
            CodeExecutionCallDelta,
            CodeExecutionResultDelta,
            UrlContextCallDelta,
            UrlContextResultDelta,
            GoogleSearchCallDelta,
            GoogleSearchResultDelta,
            McpServerToolCallDelta,
            McpServerToolResultDelta,
            FileSearchResultDelta,
        ]
    ] = Field(None, discriminator='type')


class Content(
    RootModel[
        Union[
            TextContent,
            ImageContent,
            AudioContent,
            DocumentContent,
            VideoContent,
            ThoughtContent,
            FunctionCallContent,
            FunctionResultContent,
            CodeExecutionCallContent,
            CodeExecutionResultContent,
            UrlContextCallContent,
            UrlContextResultContent,
            GoogleSearchCallContent,
            GoogleSearchResultContent,
            McpServerToolCallContent,
            McpServerToolResultContent,
            FileSearchResultContent,
        ]
    ]
):
    root: Union[
        TextContent,
        ImageContent,
        AudioContent,
        DocumentContent,
        VideoContent,
        ThoughtContent,
        FunctionCallContent,
        FunctionResultContent,
        CodeExecutionCallContent,
        CodeExecutionResultContent,
        UrlContextCallContent,
        UrlContextResultContent,
        GoogleSearchCallContent,
        GoogleSearchResultContent,
        McpServerToolCallContent,
        McpServerToolResultContent,
        FileSearchResultContent,
    ] = Field(..., description='The content of the response.', discriminator='type')


class Turn(BaseModel):
    role: Optional[str] = Field(
        None,
        description='The originator of this turn. Must be user for input or model for\nmodel output.',
    )
    content: Optional[Union[str, List[Content]]] = Field(
        None, description='The content of the turn.'
    )


class GenerationConfig(BaseModel):
    temperature: Optional[float] = Field(
        None, description='Controls the randomness of the output.'
    )
    top_p: Optional[float] = Field(
        None,
        description='The maximum cumulative probability of tokens to consider when sampling.',
    )
    seed: Optional[int] = Field(
        None, description='Seed used in decoding for reproducibility.'
    )
    stop_sequences: Optional[List[str]] = Field(
        None,
        description='A list of character sequences that will stop output interaction.',
    )
    tool_choice: Optional[ToolChoice] = Field(
        None, description='The tool choice for the interaction.'
    )
    thinking_level: Optional[ThinkingLevel] = Field(
        None, description='The level of thought tokens that the model should generate.'
    )
    thinking_summaries: Optional[ThinkingSummaries] = Field(
        None, description='Whether to include thought summaries in the response.'
    )
    max_output_tokens: Optional[int] = Field(
        None, description='The maximum number of tokens to include in the response.'
    )
    speech_config: Optional[List[SpeechConfig]] = Field(
        None, description='Configuration for speech interaction.'
    )


class ContentStart(BaseModel):
    index: Optional[int] = None
    content: Optional[Content] = None
    event_type: Literal['content.start'] = 'content.start'
    event_id: Optional[str] = Field(
        None,
        description='The event_id token to be used to resume the interaction stream, from\nthis event.',
    )


class Interaction(BaseModel):
    model: Optional[ModelOption] = Field(
        None, description='The name of the `Model` used for generating the interaction.'
    )
    agent: Optional[AgentOption] = Field(
        None, description='The name of the `Agent` used for generating the interaction.'
    )
    id: str = Field(
        ...,
        description='Output only. A unique identifier for the interaction completion.',
    )
    status: Status1 = Field(
        ..., description='Output only. The status of the interaction.'
    )
    created: Optional[AwareDatetime] = Field(
        None,
        description='Output only. The time at which the response was created in ISO 8601 format\n(YYYY-MM-DDThh:mm:ssZ).',
    )
    updated: Optional[AwareDatetime] = Field(
        None,
        description='Output only. The time at which the response was last updated in ISO 8601 format\n(YYYY-MM-DDThh:mm:ssZ).',
    )
    role: Optional[str] = Field(
        None, description='Output only. The role of the interaction.'
    )
    outputs: Optional[List[Content]] = Field(
        None, description='Output only. Responses from the model.'
    )
    system_instruction: Optional[str] = Field(
        None, description='System instruction for the interaction.'
    )
    tools: Optional[List[Tool]] = Field(
        None,
        description='A list of tool declarations the model may call during interaction.',
    )
    background: Optional[bool] = Field(
        None, description='Whether to run the model interaction in the background.'
    )
    object: Literal['interaction'] = Field(
        'interaction',
        description='Output only. The object type of the interaction. Always set to `interaction`.',
    )
    usage: Optional[Usage] = Field(
        None,
        description="Output only. Statistics on the interaction request's token usage.",
    )
    response_modalities: Optional[List[ResponseModality]] = Field(
        None,
        description='The requested modalities of the response (TEXT, IMAGE, AUDIO).',
    )
    response_format: Optional[Any] = Field(
        None,
        description='Enforces that the generated response is a JSON object that complies with\nthe JSON schema specified in this field.',
    )
    response_mime_type: Optional[str] = Field(
        None,
        description='The mime type of the response. This is required if response_format is set.',
    )
    previous_interaction_id: Optional[str] = Field(
        None, description='The ID of the previous interaction, if any.'
    )
    input: Optional[Union[str, List[Content], List[Turn], Content]] = Field(
        None, description='The inputs for the interaction.'
    )
    generation_config: Optional[GenerationConfig] = Field(
        None,
        description='Input only. Configuration parameters for the model interaction.',
    )
    agent_config: Optional[Union[DynamicAgentConfig, DeepResearchAgentConfig]] = Field(
        None, description='Configuration for the agent.', discriminator='type'
    )


class CreateModelInteractionParams(BaseModel):
    model: ModelOption = Field(
        ..., description='The name of the `Model` used for generating the interaction.'
    )
    stream: Optional[bool] = Field(
        None, description='Input only. Whether the interaction will be streamed.'
    )
    store: Optional[bool] = Field(
        None,
        description='Input only. Whether to store the response and request for later retrieval.',
    )
    id: Optional[str] = Field(
        None,
        description='Output only. A unique identifier for the interaction completion.',
    )
    status: Optional[Status3] = Field(
        None, description='Output only. The status of the interaction.'
    )
    created: Optional[AwareDatetime] = Field(
        None,
        description='Output only. The time at which the response was created in ISO 8601 format\n(YYYY-MM-DDThh:mm:ssZ).',
    )
    updated: Optional[AwareDatetime] = Field(
        None,
        description='Output only. The time at which the response was last updated in ISO 8601 format\n(YYYY-MM-DDThh:mm:ssZ).',
    )
    role: Optional[str] = Field(
        None, description='Output only. The role of the interaction.'
    )
    outputs: Optional[List[Content]] = Field(
        None, description='Output only. Responses from the model.'
    )
    system_instruction: Optional[str] = Field(
        None, description='System instruction for the interaction.'
    )
    tools: Optional[List[Tool]] = Field(
        None,
        description='A list of tool declarations the model may call during interaction.',
    )
    background: Optional[bool] = Field(
        None, description='Whether to run the model interaction in the background.'
    )
    usage: Optional[Usage] = Field(
        None,
        description="Output only. Statistics on the interaction request's token usage.",
    )
    response_modalities: Optional[List[ResponseModality]] = Field(
        None,
        description='The requested modalities of the response (TEXT, IMAGE, AUDIO).',
    )
    response_format: Optional[Any] = Field(
        None,
        description='Enforces that the generated response is a JSON object that complies with\nthe JSON schema specified in this field.',
    )
    response_mime_type: Optional[str] = Field(
        None,
        description='The mime type of the response. This is required if response_format is set.',
    )
    previous_interaction_id: Optional[str] = Field(
        None, description='The ID of the previous interaction, if any.'
    )
    input: Union[str, List[Content], List[Turn], Content] = Field(
        ..., description='The inputs for the interaction.'
    )
    generation_config: Optional[GenerationConfig] = Field(
        None,
        description='Input only. Configuration parameters for the model interaction.',
    )


class CreateAgentInteractionParams(BaseModel):
    agent: AgentOption = Field(
        ..., description='The name of the `Agent` used for generating the interaction.'
    )
    stream: Optional[bool] = Field(
        None, description='Input only. Whether the interaction will be streamed.'
    )
    store: Optional[bool] = Field(
        None,
        description='Input only. Whether to store the response and request for later retrieval.',
    )
    id: Optional[str] = Field(
        None,
        description='Output only. A unique identifier for the interaction completion.',
    )
    status: Optional[Status3] = Field(
        None, description='Output only. The status of the interaction.'
    )
    created: Optional[AwareDatetime] = Field(
        None,
        description='Output only. The time at which the response was created in ISO 8601 format\n(YYYY-MM-DDThh:mm:ssZ).',
    )
    updated: Optional[AwareDatetime] = Field(
        None,
        description='Output only. The time at which the response was last updated in ISO 8601 format\n(YYYY-MM-DDThh:mm:ssZ).',
    )
    role: Optional[str] = Field(
        None, description='Output only. The role of the interaction.'
    )
    outputs: Optional[List[Content]] = Field(
        None, description='Output only. Responses from the model.'
    )
    system_instruction: Optional[str] = Field(
        None, description='System instruction for the interaction.'
    )
    tools: Optional[List[Tool]] = Field(
        None,
        description='A list of tool declarations the model may call during interaction.',
    )
    background: Optional[bool] = Field(
        None, description='Whether to run the model interaction in the background.'
    )
    usage: Optional[Usage] = Field(
        None,
        description="Output only. Statistics on the interaction request's token usage.",
    )
    response_modalities: Optional[List[ResponseModality]] = Field(
        None,
        description='The requested modalities of the response (TEXT, IMAGE, AUDIO).',
    )
    response_format: Optional[Any] = Field(
        None,
        description='Enforces that the generated response is a JSON object that complies with\nthe JSON schema specified in this field.',
    )
    response_mime_type: Optional[str] = Field(
        None,
        description='The mime type of the response. This is required if response_format is set.',
    )
    previous_interaction_id: Optional[str] = Field(
        None, description='The ID of the previous interaction, if any.'
    )
    input: Union[str, List[Content], List[Turn], Content] = Field(
        ..., description='The inputs for the interaction.'
    )
    agent_config: Optional[Union[DynamicAgentConfig, DeepResearchAgentConfig]] = Field(
        None, description='Configuration for the agent.', discriminator='type'
    )


class InteractionEvent(BaseModel):
    event_type: Literal['interaction.start', 'interaction.complete']
    interaction: Optional[Interaction] = None
    event_id: Optional[str] = Field(
        None,
        description='The event_id token to be used to resume the interaction stream, from\nthis event.',
    )


class InteractionSseEvent(
    RootModel[
        Union[
            InteractionEvent,
            InteractionStatusUpdate,
            ContentStart,
            ContentDelta,
            ContentStop,
            ErrorEvent,
        ]
    ]
):
    root: Union[
        InteractionEvent,
        InteractionStatusUpdate,
        ContentStart,
        ContentDelta,
        ContentStop,
        ErrorEvent,
    ] = Field(..., discriminator='event_type')


# ============================================================
# LiteLLM-specific types (added manually after generation)
# ============================================================
# 
# When regenerating this file, copy these types to the end.
# See README.md for regeneration instructions.

from pydantic import PrivateAttr

from litellm.types.llms.base import BaseLiteLLMOpenAIResponseObject

# Type alias for input
InteractionInput = Union[str, Content, List[Content], List[Turn]]


class InteractionsAPIResponse(BaseLiteLLMOpenAIResponseObject):
    """
    Response from the Interactions API.
    
    Wraps the API response with LiteLLM-specific hidden params.
    """
    id: Optional[str] = None
    object: Optional[str] = "interaction"
    model: Optional[str] = None
    agent: Optional[str] = None
    status: Optional[str] = None
    created: Optional[str] = None
    updated: Optional[str] = None
    role: Optional[str] = None
    outputs: Optional[List[Dict[str, Any]]] = None
    usage: Optional[Dict[str, Any]] = None
    
    _hidden_params: dict = PrivateAttr(default_factory=dict)


class InteractionsAPIStreamingResponse(BaseLiteLLMOpenAIResponseObject):
    """
    Streaming response chunk from the Interactions API.
    
    Event types per OpenAPI spec:
    - interaction.start, interaction.status_update, interaction.complete
    - content.start, content.delta, content.stop
    - error
    """
    event_type: Optional[str] = None
    id: Optional[str] = None
    object: Optional[str] = "interaction"
    model: Optional[str] = None
    agent: Optional[str] = None
    status: Optional[str] = None
    created: Optional[str] = None
    updated: Optional[str] = None
    role: Optional[str] = None
    outputs: Optional[List[Dict[str, Any]]] = None
    usage: Optional[Dict[str, Any]] = None
    delta: Optional[Dict[str, Any]] = None
    
    _hidden_params: dict = PrivateAttr(default_factory=dict)


class DeleteInteractionResult(BaseLiteLLMOpenAIResponseObject):
    """Result of deleting an interaction."""
    success: bool = True
    id: Optional[str] = None
    
    _hidden_params: dict = PrivateAttr(default_factory=dict)


class CancelInteractionResult(BaseLiteLLMOpenAIResponseObject):
    """Result of cancelling an interaction."""
    id: Optional[str] = None
    status: Optional[str] = None
    
    _hidden_params: dict = PrivateAttr(default_factory=dict)


# Backwards compatibility aliases
InteractionTool = Tool
InteractionToolChoiceConfig = ToolChoiceConfig
InteractionsAPIOptionalRequestParams = Dict[str, Any]
