"""
Type definitions for Google Interactions API

Auto-generated from OpenAPI spec: https://ai.google.dev/static/api/interactions.openapi.json
See README.md for regeneration instructions.
"""

from litellm.types.interactions.generated import (
    AgentOption,
    Annotation,
    AudioContent,
    CancelInteractionResult,
    CodeExecution,
    CodeExecutionCallContent,
    CodeExecutionResultContent,
    ComputerUse,
    Content,
    ContentDelta,
    ContentStart,
    ContentStop,
    CreateAgentInteractionParams,
    CreateModelInteractionParams,
    DeepResearchAgentConfig,
    DeleteInteractionResult,
    DocumentContent,
    DynamicAgentConfig,
    ErrorEvent,
    FileSearch,
    FileSearchResultContent,
    Function,
    FunctionCallContent,
    FunctionResultContent,
    GenerationConfig,
    GoogleSearch,
    GoogleSearchCallContent,
    GoogleSearchResultContent,
    ImageContent,
    Interaction,
    InteractionEvent,
    InteractionInput,
    InteractionsAPIOptionalRequestParams,
    InteractionsAPIResponse,
    InteractionsAPIStreamingResponse,
    InteractionSseEvent,
    InteractionTool,
    InteractionToolChoiceConfig,
    McpServer,
    McpServerToolCallContent,
    McpServerToolResultContent,
    ModelOption,
    ResponseModality,
)
from litellm.types.interactions.generated import (
    Status3 as InteractionStatus,  # Main request/response types; Content types; Turn for multi-turn conversations; Tool types; Config types; Usage; Status enum; Events for streaming; Agent configs; Model/Agent options; Response modality; Annotation; LiteLLM types; Backwards compat aliases
)
from litellm.types.interactions.generated import (
    TextContent,
    ThoughtContent,
    Tool,
    ToolChoiceConfig,
    Turn,
    UrlContext,
    UrlContextCallContent,
    UrlContextResultContent,
    Usage,
    VideoContent,
)

__all__ = [
    # Generated types
    "CreateModelInteractionParams",
    "CreateAgentInteractionParams",
    "Interaction",
    "Content",
    "TextContent",
    "ImageContent",
    "AudioContent",
    "DocumentContent",
    "VideoContent",
    "ThoughtContent",
    "FunctionCallContent",
    "FunctionResultContent",
    "CodeExecutionCallContent",
    "CodeExecutionResultContent",
    "UrlContextCallContent",
    "UrlContextResultContent",
    "GoogleSearchCallContent",
    "GoogleSearchResultContent",
    "McpServerToolCallContent",
    "McpServerToolResultContent",
    "FileSearchResultContent",
    "Turn",
    "Tool",
    "Function",
    "GoogleSearch",
    "CodeExecution",
    "UrlContext",
    "ComputerUse",
    "McpServer",
    "FileSearch",
    "GenerationConfig",
    "ToolChoiceConfig",
    "Usage",
    "InteractionStatus",
    "InteractionEvent",
    "InteractionSseEvent",
    "ContentStart",
    "ContentDelta",
    "ContentStop",
    "ErrorEvent",
    "DynamicAgentConfig",
    "DeepResearchAgentConfig",
    "ModelOption",
    "AgentOption",
    "ResponseModality",
    "Annotation",
    # LiteLLM types
    "InteractionInput",
    "InteractionsAPIResponse",
    "InteractionsAPIStreamingResponse",
    "DeleteInteractionResult",
    "CancelInteractionResult",
    "InteractionsAPIOptionalRequestParams",
    # Backwards compat
    "InteractionTool",
    "InteractionToolChoiceConfig",
]
